/* Based on http://www.geeks3d.com/20110405/fxaa-fast-approximate-anti-aliasing-demo-glsl-opengl-test-radeon-geforce/3/ */

#version 330

uniform sampler2D tex0;
uniform vec4 invRtSize;

in vec4 posPos;

out vec4 oColor;

vec3 Fxaa( 
  vec4 pp, // Output of FxaaVertexShader interpolated across screen.
  sampler2D tex, // Input texture.
  vec2 rcpFrame) // Constant {1.0/frameWidth, 1.0/frameHeight}.
{   
/*---------------------------------------------------------*/
	const float FXAA_SPAN_MAX = 8.0;
	const float FXAA_REDUCE_MUL = 1.0/8.0;
    const float FXAA_REDUCE_MIN = 1.0/128.0;
/*---------------------------------------------------------*/
    vec3 rgbNW = textureLod(tex, pp.zw, 0).xyz;
    vec3 rgbNE = textureLodOffset(tex, pp.zw, 0, ivec2(1,0)).xyz;
    vec3 rgbSW = textureLodOffset(tex, pp.zw, 0, ivec2(0,1)).xyz;
    vec3 rgbSE = textureLodOffset(tex, pp.zw, 0, ivec2(1,1)).xyz;
    vec3 rgbM  = textureLod(tex, pp.xy, 0).xyz;
/*---------------------------------------------------------*/
    vec3 luma = vec3(0.299, 0.587, 0.114);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
/*---------------------------------------------------------*/
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
/*---------------------------------------------------------*/
    vec2 dir; 
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
/*---------------------------------------------------------*/
    float dirReduce = max(
        (lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),
        FXAA_REDUCE_MIN);
    float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
    dir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX), 
          max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX), 
          dir * rcpDirMin)) * rcpFrame.xy;
/*--------------------------------------------------------*/
    vec3 rgbA = (1.0/2.0) * (
        textureLod(tex, pp.xy + dir * (1.0/3.0 - 0.5), 0).xyz +
        textureLod(tex, pp.xy + dir * (2.0/3.0 - 0.5), 0).xyz);
    vec3 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (
        textureLod(tex, pp.xy + dir * (0.0/3.0 - 0.5), 0).xyz +
        textureLod(tex, pp.xy + dir * (3.0/3.0 - 0.5), 0).xyz);
    float lumaB = dot(rgbB, luma);
    if((lumaB < lumaMin) || (lumaB > lumaMax)) return rgbA;
    return rgbB; }

void main() 
{
  vec4 c = vec4(0.0);
  c.rgb = Fxaa(posPos, tex0, invRtSize.xy);
  c.a = 1.0;
  oColor = c;
}
